package examples.integration.loanratesejb;

import javax.resource.cci.*;

import javax.ejb.Stateless;
import javax.ejb.Remote;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.annotation.*;

@Stateless 
@Remote(LoanRates.class)
@TransactionManagement(TransactionManagementType.BEAN)
public class LoanRatesBean implements LoanRates{

     @Resource (name="OutboundLoanJNDIName")
     public javax.resource.cci.ConnectionFactory connFactory;
  
     public float getHomeEquityRate() {
          float retVal=0;

          System.out.println("LoanRatesBean.getHomeEquityRate() called");

          try {
               javax.resource.cci.Connection myCon = connFactory.getConnection();
               javax.resource.cci.Interaction interaction = myCon.createInteraction();
               javax.resource.cci.MappedRecord recordIn = connFactory.getRecordFactory().createMappedRecord("");

               recordIn.put("HomeEquityRate","");

               javax.resource.cci.MappedRecord recordOut = 
                    (javax.resource.cci.MappedRecord)interaction.execute(null, (javax.resource.cci.Record)recordIn);

               myCon.close();

               Object result = recordOut.get("HomeEquityRate");
               retVal = ((Float)result).floatValue();

          } catch(Exception e) {

               e.printStackTrace();
          }

          return retVal;
     }  
}